
/*===============================================================================

									  Debug.h

===============================================================================*/


#define mtErr 0xACE

#ifndef dprintfCapable
	#define dprintfCapable 0
#endif

#if defined (applec) && !defined (powerc) && dprintfCapable

	#include "Exceptions.h"

#else /* THINK C, Metrowerks, etc. */

	#define DEBUGOFF		0
	#define DEBUGWARN		1
	#define DEBUGON			2
	#define DEBUGFULL		3
	
	#ifndef DEBUGLEVEL
		#define DEBUGLEVEL DEBUGWARN
	#endif DEBUGLEVEL
	
	static void PlaceHolder(void);

	#define debugon (DEBUGLEVEL > DEBUGWARN)

	#define check(assertion)

	#define ncheck(assertion)

	#define check_action(assertion, action)

	#define ncheck_action(assertion, action)

	#define require(assertion, exception)									\
		if (true) {															\
			if (assertion) ;												\
			else {															\
				{ if (DEBUGLEVEL > DEBUGWARN)							\
					Debugger(); }										\
				goto exception;												\
			}																\
		} else PlaceHolder()

	#define nrequire(assertion, exception)									\
		if (true) {															\
			if (assertion) {												\
				goto exception;												\
			}																\
		} else PlaceHolder()

	#define require_action(assertion, exception, action)					\
		if (true) {															\
			if (assertion) ;												\
			else {															\
				{ action }													\
				{ if (DEBUGLEVEL > DEBUGWARN)							\
					Debugger(); }										\
				goto exception;												\
			}																\
		} else PlaceHolder()

	#define nrequire_action(assertion, exception, action)					\
		if (true) {															\
			if (assertion) {												\
				{ action }													\
				goto exception;												\
			}																\
		} else PlaceHolder()
	

#endif

#if debugon
	#if dprintfCapable
/*		#define DebugMsg(theFormat) dprintf(trace, "File %s\nLine %d\n" theFormat, __FILE__, __LINE__) */
/*		#define DebugMsgArg1(theFormat, arg1) dprintf(trace, "File %s\nLine %d\n" theFormat, __FILE__, __LINE__, arg1) */
		#define DebugMsg(theFormat) dprintf(trace, theFormat)
		#define DebugMsgArg1(theFormat, arg1) dprintf(trace, theFormat, arg1)
		#define DebugMsgArg2(theFormat, arg1, arg2) dprintf(trace, theFormat, arg1, arg2)
		#define DebugMsgArg3(theFormat, arg1, arg2, arg3) dprintf(trace, theFormat, arg1, arg2, arg3)
	#else
		#define DebugMsg(theFormat) DebugStr ((ConstStr255Param)"\p"#theFormat)
		#define DebugMsgArg1(theFormat, arg1) DebugStr ((ConstStr255Param)"\p"#theFormat)
		#define DebugMsgArg2(theFormat, arg1, arg2) DebugStr ((ConstStr255Param)"\p"#theFormat)
		#define DebugMsgArg3(theFormat, arg1, arg2, arg3) DebugStr ((ConstStr255Param)"\p"#theFormat)
	#endif
#else
	#define DebugMsg(theFormat)
	#define DebugMsgArg1(theFormat, arg1)
	#define DebugMsgArg2(theFormat, arg1, arg2)
	#define DebugMsgArg3(theFormat, arg1, arg2, arg3)
#endif

#define debugfull (DEBUGLEVEL > DEBUGON)

#if debugfull
	#define DebugFullMsg(theFormat) DebugMsg(theFormat)
	#define DebugFullMsgArg1(theFormat, arg1) DebugMsgArg1(theFormat, arg1)
	#define DebugFullMsgArg2(theFormat, arg1, arg2) DebugMsgArg2(theFormat, arg1, arg2)
	#define DebugFullMsgArg3(theFormat, arg1, arg2, arg3) DebugMsgArg3(theFormat, arg1, arg2, arg3)
#else
	#define DebugFullMsg(theFormat)
	#define DebugFullMsgArg1(theFormat, arg1)
	#define DebugFullMsgArg2(theFormat, arg1, arg2)
	#define DebugFullMsgArg3(theFormat, arg1, arg2, arg3)
#endif
